#include <stdint.h>
#include <system.h>
#include <usb_device.h>

#include <led_usb_status.h>

extern uint8_t TX_counter;
extern uint8_t RX_counter;

void LEDUpdateUSBStatus(void *direction)
{
    USTAT_FIELDS usb_status;
    usb_status.Val = *(uint8_t *)direction;
    
    switch(USBGetDeviceState())
    {
        case CONFIGURED_STATE:
            switch(usb_status.direction)
            {
                case TRANSMITT:
                    HIDTxLED = 0;
                    if(!TX_counter)TX_counter++;
                    break;
                case RECEIVE:
                    HIDRxLED = 0;
                    if(!RX_counter)RX_counter++;
                    break;
            }
            break;
        case DETACHED_STATE:
            HIDTxLED = 0;
            HIDRxLED = 0;
            break;
    }
}